/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ToolActionsModule(Set<ToolAction> actions) implements ToolActionModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_ACTION);
    public static final GenericLoaderRegistry.IGenericLoader<ToolActionsModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ToolActionsModule>(){

        @Override
        public ToolActionsModule deserialize(JsonObject json) {
            return new ToolActionsModule((Set<ToolAction>)ImmutableSet.copyOf(JsonHelper.parseList(json, "tool_actions", (element, name) -> ToolAction.get((String)class_3518.method_15287((JsonElement)element, (String)name)))));
        }

        @Override
        public ToolActionsModule fromNetwork(class_2540 buffer) {
            int size = buffer.method_10816();
            ImmutableSet.Builder actions = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                actions.add((Object)ToolAction.get((String)buffer.method_10800(Short.MAX_VALUE)));
            }
            return new ToolActionsModule((Set<ToolAction>)actions.build());
        }

        @Override
        public void serialize(ToolActionsModule object, JsonObject json) {
            JsonArray actions = new JsonArray();
            for (ToolAction action : object.actions) {
                actions.add(action.name());
            }
            json.add("actions", (JsonElement)actions);
        }

        @Override
        public void toNetwork(ToolActionsModule object, class_2540 buffer) {
            buffer.method_10804(object.actions.size());
            for (ToolAction action : object.actions) {
                buffer.method_10814(action.name());
            }
        }
    };

    public ToolActionsModule(ToolAction ... actions) {
        this((Set<ToolAction>)ImmutableSet.copyOf((Object[])actions));
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.actions.contains(toolAction);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }
}

